function pi_i=stationary_probt(Q);
%stationary probabilities of continuous time Markov chain
%SYNTAX
%pi_i=stationary_probt(Q);
%INPUTS
%Q is the instantaneous rate matrix
%OUTPUTS
%pi_i is the vector of stationary probabilities
%USES
%sorted_eigs.m
%NOTES
%old algorithm from Grassmann, W.K., Taksar, M.I. and Heyman, D.P. (1985)
%Regenerative analysis and steady state distributions for Markov chains
%Operations Research 33(5):1107=1116
%slower than the current version in matlab, but might be useful in C
%THIS VERSION IS FOR qij = RATE FROM J TO I (OTHER WAY ROUND TO MY USUAL
%WAY)


[lambda,W,V]=sorted_eigs(Q);
pi_i=[W(:,1)]';

%OLD ALGORITHM
%A=Q';
%N=size(A,1);
%r=zeros(1,N);
%for n=N:-1:2
%    S=sum(A(n,1:n-1));
%    A(1:n-1,n)=A(1:n-1,n)/S;
%    A(1:n-1,1:n-1)=A(1:n-1,1:n-1)+A(1:n-1,n)*A(n,1:n-1);
%end;
%tot=1;
%r(1)=1;
%for j=2:N
%    r(j)=A(1,j)+sum(r(2:j-1)*A(2:j-1,j));
%    tot=tot+r(j);
%end;
%pi_i=r./tot;