function [lambda,W,V]=sorted_eigs(Q);
%get sorted eigenvalues and vectors, in descending order of real part of
%eigenvector
%SYNTAX
%[lambda,W,V]=sorted_eigs(Q);
%INPUTS
%OUTPUTS
%lambda is an array of eigenvalues in descending order of real part
%W is an array of corresponding right eigenvectors (cols), scaled so that the
%first one sums to 1
%V is an array of corresponding left eigenvectors

%get the eigenvalues and eigenvectors
[W,d]=eig(Q);%columns of W are right eigenvectors
lambda=diag(d);
%sort the eigenvalues and eigenvectors so that the first is dominant
[ldum,ind]=sort(real(lambda),'descend');
lambda=lambda(ind);

W=W(:,ind);
W=W/sum(W(:,1));%scale so first eigenvector sums to 1
V=conj(inv(W));%rows of V are left eigenvectors: see Caswell p 108