function nout=multinomial(P,n);
%sampling from a multinomial distribution
%SYNTAX
%nout=multinomial(P,n);
%INPUTS
%P is a vector specifying multinomial probabilities
%n is the number of samples to take
%OUTPUTS
%nout is a vector of number of samples falling into each category

ncat=length(P);
nout=zeros(size(P));
Pc=cumsum(P);
tiny=1e-10;
if abs(Pc(ncat)-1)>tiny
	disp('probabilities don''t sum to 1!');
	nout=nout*NaN;
	return;
end;
r=rand(1,n);
low=0;
for a=1:ncat%might be a loop-free way to do this?
	nout(a)=sum(r<=Pc(a))-sum(r<low);
	low=Pc(a);
end;