function negl=mlq_ufun3(lest,nobs);
%calculate negative log likelihood of a Q matrix given observed transition
%probs: this version for unconstrained optimization with log transform
%and partial likelihood
%SYNTAX
%negl=mlq_ufun3(lest,nobs);
%INPUTS
%lest is a vector of logs of Q matrix elements, excluding diagonals, going down
%then across
%nobs is a matrix of number of times each transition was observed with a
%time step of 1 unit
%OUTPUTS
%negl is partial negative log likelihood of data nobs given Q matrix
%USES
%Qfromest.m
%plike.m

est=exp(lest);%turn parameters back to original scale

%make parameters into a Q matrix
ncat=size(nobs,1);
Q=Qfromest(est,ncat);

%use matrix exponential to turn Q into P
%assume time interval is one unit
P=expm(Q);

negl=-plike(nobs,P);

