function [negl,neglobs,neglz,Q]=get_Q_like(nobs);
%find best Q matrix with non-negative off-diags
%given a matrix of counts o each transition
%SYNTAX
%[negl,neglobs,neglz,Q]=get_Q_like(nobs);
%INPUTS
%nobs is a matrix of counts of each transition
%OUTPUTS
%negl is partial negative log likelihood for optimized Q with non-negative
%off-diags (actually has strictly positive off-diags)
%neglobs is partial negative log likleihood for the ML P matrix
%neglz is partial negative log likelihood for optimized Q matrix with tiny
%offdiags (<2*eps) set to zero
%Q is the estimated rate matrix
%USES
%optimization toolbox
%mlq_ufun3.m
%Qfromest.m
%plike.m
%NOTES
%USES UNCONSTRAINED OPTIMIZATION (FMINUNC) WITH LOG TRANSFORM: FAST AND RELIABLE, BUT TRUE ZEROS
%NOT POSSIBLE
%1/11/05: Changed the initial estimate: we sometimes get complex matrices
%from logm(P), so real(logm(P)) is probably a more sensible starting point
csum=sum(nobs);
ncat=size(nobs,1);
temp=csum(ones(ncat,1),:);
P=nobs./temp;
ncat=size(nobs,1);
np=ncat*(ncat-1);%number of parameters in Q matrix

options=optimset('fminunc');
options=optimset(options,'largescale','off','display','final','MaxFunEvals',500*np);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%test: faster bootstrapping by fewer iterations
%options=optimset(options,'MaxIter',5);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%find the best Q with negative off-diags
%start with logm P, but set negative off-diags to small values
temp=real(logm(P));
ind=find(temp<0);
temp(ind)=eps;
ind=find(~eye(ncat));
init=temp(ind);
[est,negl,exitflag,optoutput]=fminunc(@mlq_ufun3,log(init),options,nobs);
est=exp(est);

%negative log likelihood for ML P matrix
neglobs=-plike(nobs,P);

%set tiny elements of estimated Q to zero
Q=Qfromest(est,ncat);
ind=find(abs(Q)<2*eps);
Qzt=Q;
Qzt(ind)=0;
Pzt=expm(Qzt);
neglz=-plike(nobs,Pzt);

