function nbs=Qmatrix_bootstrap(P,pi_i,nsites,ntimes,nmiss);
%parametric bootstrap sample for Markov community model    
%SYNTAX
%nbs=Qmatrix_bootstrap(P,pi_i,nsites,ntimes,nmiss);
%INPUTS
%P is the transition matrix
%pi_i is the stationary probability of the transition matrix
%nsites is number of sites sampled each time step
%ntimes is number of time points at which each site is sampled
%nmiss is number of missing data (distributed randomly over the
%transitions)
%OUTPUTS
%nbs is matrix where element ij is number of transitions from state j to state i
%USES
%multinomial.m
%NOTES
%assumes every observation equally likely to be missing: sample without
%replacement

ncat=length(pi_i);
ntrans=zeros(ncat);

%initialize with multinomial sample from stationary distribution
csample=multinomial(pi_i',nsites);

%iterate over defined number of time periods
for t=2:ntimes
    newsample=zeros(ncat,1);
    for c=1:ncat
        nt=multinomial(P(:,c),csample(c));%sample transitions out of a state
        ntrans(:,c)=ntrans(:,c)+nt;%record these transitions
        newsample=newsample+nt;
    end;
    csample=newsample;%update the population vector for next time iteration
end;

%make random deletions to simulate missing data: sample without replacement
nt=ntrans(:);
nct=ncat*ncat;
hn=randperm(sum(nt));
hn=hn(1:nmiss);
nc=cumsum(nt);
hits=zeros(1,nct);
low=0;
for a=1:nct%might be a loop-free way to do this?
	hits(a)=sum(hn<=nc(a))-sum(hn<=low);
	low=nc(a);
end;
nbs=ntrans-reshape(hits,ncat,ncat);
