function Q=Qfromest(est,ncat);
%reconstruct a Q matrix from a vector of off-diagonal entries
%SYNTAX
%Q=Qfromest(est,ncat);
%INPUTS
%est is a vector of off-diagonal elements, going down then across
%ncat is number of categories
%OUTPUTS
%Q is ncat by ncat, with off-diagonal elements est, and diagonals -col sums

Q=zeros(ncat);

ind=find(~eye(ncat));
Q(ind)=est;
ind=find(eye(ncat));
Q(ind)=-sum(Q);
