function [Q,negl,nobs,neglobs,neglz,twodelta,p,timetaken]=ML_Q_est5(P,obs_csum,reps,nsites,ntimes);
%ML estimation of a Q (instantaneous rate) matrix from a P (one-time-unit
%transition) matrix and total number of observations of transitions from each state, with all
%off-diag elements of Q constrained to strictly
%positive (if we use fminunc and log transform, as in current version)
%Also does parametric bootstrap test: is observed -2 delta log l bigger
%than we'd expect if the estimated Q matrix was the true one?
%THIS VERSION: partial likelihood, and bootstrap by sampling from
%stationary distribution then iterating over number of time periods
%31/10/05: Thought about how to fix the non-real likelihoods that occur in
%some cases
%SYNTAX
%[Q,negl,nobs,neglobs,neglz,twodelta,p,timetaken]=ML_Q_est5(P,obs_csum,reps,nsites,ntimes);
%INPUTS
%P is the observed transition matrix for time step of 1 unit
%obs_csum is number of observed transitions from each state
%reps is number of parametric bootstrap reps to run
%ntimes is number of time periods sampled in original data
%nsites is number of sites sampled in original data
%OUTPUTS
%Q is the ML Q matrix with constraint that all off-diags positive
%negl is partial negative log likelihood for this Q matrix
%nobs is array of number of observations of each transition (with some
%rounding if the P matrix wasn't reported exactly)
%neglobs is partial negative log likelihood if we use observed
%transition frequencies (which are the ML estimates)
%neglz is partial negative log likelihood if we
%set any tiny elements of Q (<2*eps) to zero
%twodelta is twice difference in partial log likelihoods between the 
%Q matrix and the empirical P matrix: first row is observed,
%remaining reps rows are from parametric bootstrap.  First col is for the Q
%matrix as estimated, second is with tiny elements of Q set to zero
%p is proportion of reps with twodelta>=observed (first col Q as estimated,
%second col with tiny elements of Q set to zero)
%Hboot is distribution of bootstrapped jump matrix entropy (first entry is
%for estimated Q, remaining are from parametric bootstrap)
%nzboot is proportion of non-zero (really, >2*eps) off-diagonal entries (same format)
%timetaken is clock time used
%USES
%optimization toolbox function fminunc
%mlq_ufun3.m (gets partial likelihoods)
%get_Q_like.m
%Qmatrix_bootstrap.m
%stationary_probt.m

tzero=clock;
ncat=size(P,1);
nobs=round(P*diag(obs_csum));


%fit the observed data
disp('fitting observed data');
[negl,neglobs,neglz,Q]=get_Q_like(nobs);
twodelta=zeros(reps+1,2);
twodelta(1,:)=-2*[neglobs-negl neglobs-neglz];


disp('parametric bootstrap');
%parametric bootstrap test
Pbs=expm(Q);

pi_i=stationary_probt(Q);

%work out how many missing data there must be
nmiss=(ntimes-1)*nsites-sum(nobs(:));

for r=2:reps+1
    disp(['rep ',num2str(r-1)]);
    
    %generate this bootstrap sample
    nbs=Qmatrix_bootstrap(Pbs,pi_i,nsites,ntimes,nmiss);
    
    %likelihoods for this bootstrap sample
    [neglb,neglobsb,neglzb,Qb]=get_Q_like(nbs);
    twodelta(r,:)=-2*[neglobsb-neglb neglobsb-neglzb];
end;
ind1=(twodelta(2:reps+1,1)>=twodelta(1,1));
ind2=(twodelta(2:reps+1,2)>=twodelta(1,2));
p=[sum(ind1)/reps sum(ind2)/reps];
timetaken=etime(clock,tzero);