% multic.m --- MultiColour ordering illustration
%
% Usage: [order block colour]=multi(A, nc)  % A_{nxn} ordered in
%     or                order=multi(A, nc)  %         in nc colours
% e.g. A=delsq( numgrid('L',12) ); spy(A), title('A'),figure
%      a = multic(A,3);  B=A(a,a); spy(B), title('A re-ordered')

function [order,block,colour]=multi(A,nc)
 if nargin<2,help multic; return; end
 n=size(A,1); colour=zeros(n,1); 
for k = 1:n
%disp('---------------------------------------------------')
 row=find(A(k,:)); col=find(A(:,k)); % get hold of nz index
 list = unique([row(:); col(:)]);
 clist=colour(list); % neighbour's colours
 left = setdiff(1:nc, clist); % left colours to use
 if length(left)>0
 colour(k) = left(1); % pick the smallest value
 else
 colour(k) = 1;
 end
 %%% k,clist,left, colour(k), pause
end % k
    % colour has values 1:nc now
[v I]=sort(colour); J=1:n; order = J(I);
if nargout>1, block=[];
   for k=1:nc, block=[block length(find(colour==k))]; end
end
    count = nc - length( setdiff(1:nc,colour) );
fprintf('\tmultic.m:  re-order A_{%d x %d} using %d colours\n',n,n,count)

