% mat_prt4.m --- printing 2 matrices side-by-side (vectors also)
%                to include as verbatim in LaTeX
% Usage: mat_prt4(A,B,string_ab,A_is,B_is)
% ======  %8.4f instead of %6.1f
%        A_is =           B_is =
%         x x x x         x x x x
%         x x x x         x x x x
%         x x x x         x x x x
%         x x x x         x x x x
function mat_prt(A,B,string_ab,A_is,B_is,sep_on)
if nargin<1, help mat_prt4; return; end
if nargin<2, B=[]; end
   [n1 n2]=size(A); [m1 m2]=size(B);
if nargin<6
   sep_on = 0; % <========================== Separator On / Off
end
global n_o
if size(n_o)==0; n_o=1; end 
   n22 = round(n2/2); m22 = round(m2/2);
if nargin<3, string_ab = '    '; end
if nargin<4, A_is = 'A '; if n1+n2==0,A_is='  ';end; end
if nargin<5, B_is = 'B '; if m1+m2==0,B_is='  ';end; end
first = 1; if m1>n1, first=2; end % who ends last
nm = min(m1,n1); nm2=max(n1,m1);
if nm2<1, return, end
     nm22 = round(nm/2);
     nm21 = nm+round((nm2-nm)/2);
   Gap0='   '; Gaps=[]; nmax=max([nm2 nm21 nm22 n2 m2]);
for k=1:max(nmax*200,1)
   Gaps=[Gaps Gap0];
end
   siz_A_is = min(  max(size(A_is,2)),  n2*9-4); A_is = A_is(1:siz_A_is);
   Gapn= n2*9 -3 - siz_A_is;
if sep_on==1
   Gapn= n2*9 -1 - siz_A_is;
end
   if Gapn>length(Gaps), 
      Gapn,Gaps=length(Gaps), error('check'); end
   if Gapn>=1, Gap=Gaps(1:Gapn); else; Gap=[]; end

if n1<1
fprintf('\n%s  %s =', string_ab, B_is); 
else
fprintf('\n%s = %s%s  %s =',A_is, Gap, string_ab, B_is); 
end
disp(' ');

for i=1:nm
jump=0;
    for j=1:n2, 
        if n_o==0
         fprintf('%8.0f ',A(i,j)),
        else
         fprintf('%8.4f ',A(i,j)),
        end
        if j==n22 & sep_on==1, fprintf(' :'); end
        jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
    end
            fprintf('%s ',string_ab)
    for j=1:m2, 
        if n_o==0
         fprintf('%8.0f ',B(i,j)),
        else
         fprintf('%8.4f ',B(i,j)),
        end
        if j==m22 & sep_on==1, fprintf(' :'); end
        jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
    end
fprintf('\n')
%================================ half row time
  if i==nm22 & sep_on==1
  for j=1:n2, fprintf('---------'),
      if j==n22 & sep_on==1, fprintf(' :'); end
      jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
  end
            fprintf('%s ',string_ab)
  for j=1:m2, fprintf('---------'),
    if j==m22 & sep_on==1, fprintf(' :'); end
      jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
  end
  fprintf('\n')
  end
%================================ half row time
end

%________________________ Below for the long rows
for i=nm+1:nm2
jump=0;

if first==1
   for j=1:n2, 
        if n_o==0
         fprintf('%8.0f ',A(i,j)),
        else
         fprintf('%8.4f ',A(i,j)),
        end
       if j==n22 & sep_on==1, fprintf(' :'); end
   jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
   end
else
   for j=1:n2, fprintf('         '),
       if j==n22 & sep_on==1, fprintf(' :'); end
       jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
   end
end
            fprintf('%s ',string_ab)
if first==2
   for j=1:m2, fprintf('%8.4f ',B(i,j))
       if j==m22 & sep_on==1, fprintf(' :'); end
   jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
   end % if
end
fprintf('\n')
%================================ half row time
  if i==nm21 & sep_on==1
  for j=1:n2, fprintf('---------'),
      if j==n22 & sep_on==1, fprintf(' :'); end
    jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
  end
            fprintf('%s ',string_ab)
  for j=1:m2, fprintf('---------'),
    if j==m22 & sep_on==1, fprintf(' :'); end
    jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
  end
  fprintf('\n')
  end
%================================ half row time
end 
