% mat_pr0.m --- Printing a matrix in block form (say A of 3 x 3 's)
%                   to include as verbatim in LaTeX
% Extras ------ global sep_on n_o
%               sep_on=1 (show 2 x 2 blocks);  n_o = 0 (remove decimals)
% Usage: mat_pr0(A,nb,sep,no, scale) % size(A)=nb.*[m n],
%            sep=1/0 (grid on/off), no=0/1 (digits) scale = 0/1 (on/off)
% e.g. mat_pr0(A)  mat_pr0(A,4)  mat_pr0(A,4,1)  mat_pr0(A,4,1,1)
%      mat_pr0(A,[4 3],1,1,0)
%             A_is = | x x | x x |      [Different from mat_prt / mat_pri]
%                    | x x | x x |  
%                    | x x | x x | 
%SEE also  mat_prt, mat_prt2, mat_prt4 
function mat_pr0(A,nb,sep_in,n_o,scale)
if nargin<1, help mat_pr0; return; end
if ~exist('B'), B=[];  end
if nargin<2 | ~exist('nb'), nb=inf;  end
if nargin<3 | ~exist('sep_in'), sep_in=0;  end
if nargin<4 | ~exist('n_o'), n_o=0;  end
if nargin<5 | ~exist('scale'), scale=0;  end
if size(nb,2)>1
   nbx=nb(1); nby=nb(2);
else
   nbx=nb; nby=nb;
end

   [n1 n2]=size(A); nm = n1; 
   sep_on=sep_in; 

if nargin<3 & size(sep_on,1)==0
   sep_on = 0; % <========================== Separator On / Off
end

if scale==1
Xim = max(abs(A)); % From chop.m - scale in case of large A's
Xin=Xim;
X=Xin+(Xin==0); [nx,mx] = size(X); unit=1; n=1;
exponent=unit.*((10*ones(nx,mx)).^(floor(log10(X))-n+1)) ;
Xin=round(log10(max(exponent)));
if Xin==0 & Xim~=0, Xin=-0.1; end
if Xin>2 | -Xin>0, factor=(Xin-2); A = A/10^factor; else, factor=0; end
  factor=round(factor);
else
  factor=0;
end

if sep_on==1, fprintf('|'); 
        col=0;
  for j=1:n2, 
       if n_o==0
          fprintf('---'),
       else
          fprintf('------'),
       end
        col=col+1;
      if rem(col,nby)==0 & sep_on==1, fprintf('-+'); end
  end
      fprintf('\n'); 
end

  row=0;
for i=1:nm
  row=row+1; jump=0; col=0;
  if sep_on==1, fprintf('|'); end
    for j=1:n2, 
        col=col+1;
        if n_o==0
         fprintf('%3.0f',A(i,j)),
        else
         fprintf('%6.1f',A(i,j)),
        end
        if rem(col,nby)==0 & sep_on==1, fprintf(' |'); end
        jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
    end
fprintf('\n')
%================================ half row time
  if rem(row,nbx)==0 & sep_on==1
        fprintf('|');
        col=0;
  for j=1:n2, 
       if n_o==0
          fprintf('---'),
       else
          fprintf('------'),
       end
        col=col+1;
      if rem(col,nby)==0 & sep_on==1, fprintf('-+'); end
      jump = jump+1; if jump>1E+9; jump, fprintf(' ...\n'); jump=0; end
  end
  fprintf('\n')
  end
%================================ half row time
end

   if factor~=0, fprintf('\t Matrix scaled by 10^%d\n',factor); end
%   if max(max(abs(A)))>=10^2 | min(min(abs(A)))<0.1  | min(min(abs(B)))<0.1  
%fprintf('\t TRY also  mat_prt mat_prt2, mat_prt4  (set global sep_on n_o IF needed)\n')
%   end
