% ilu_0.m ----- ILU(0) method for L*U \approx A
%
% Usage:  [L U]=ilu_0(A);
%                assume A=sparse(A)
% e.g  rand('seed',0); A=rand(8); A=A.*(A>.4) + diag(rand(8,1))  % sparse A
%      [L U]=ilu_0(A);          er1=norm(L*U-A,1), nz1=nnz(L+U)
function [L,U]=ILU_0_method(A);
 if nargin<1, help ilu_0; return;end; 
n = size(A,1); B = A; %optional to kepp A unchanged
TOL=1.0E-12;

for i=2:n

  for k=1:(i-1)
  if abs(A(i,k))>TOL %--------------- pattern nz(A)
    B(i,k) = B(i,k) / B(k,k);
    for j=(k+1):n 
    if abs(A(i,j))>TOL %------------- pattern nz(A)
    B(i,j) = B(i,j) - B(i,k)*B(k,j);
    end %if
    end %j
  end %if
  end %k 

end %i 
  L = tril(B,-1) + speye(n);
  U = triu(B);
