% gj_ek.m _________ Illustration of product of Gauss-Jordan transforms
% 
more on

format compact, eval(['help ' mfilename])
 n=7
E1 = eye(n); E3 = eye(n);
disp('----------------------------------------------------------')
E1(:,1) = rand(n,1); %% E1(1,1)=1
E3(:,3) = rand(n,1); %% E3(3,3)=1
  E1, E3
E13 = E1*E3
E31 = E3*E1
disp(' Here E13=E1*E3,  E31=E3*E1 --- Note patterns remain but contents change.')
disp('Swap products Ua and Eb (1)__different cols______')
      Ua = eye(n); Eb = eye(n);
Ua(1:2,2) = rand(2,1)
Eb(4:n,3) = rand(n-3,1) 
UE = Ua*Eb
EU = Eb*Ua
disp(' Here UE=Ua*Eb, EU=Eb*Ua --- can be viewed as 2 x 2 block products')

disp('Swap products Ua and Eb (2)__same cols foe E3_____')
      UA = eye(n); EB = eye(n);
UA(1:3,3) = rand(3,1)
EB(4:n,3) = rand(n-3,1) 
U_E = UA*EB
E_U = EB*UA
disp(' Here U_E=UA*EB, E_U=EB*UA ')

disp('Compute inv(E3)_________________')
EI3 = E3;
col = - EI3(:,3)/EI3(3,3);  col(3) = 1/E3(3,3);
EI3(:,3) = col
disp('  Now check if EI3 = inv(E3)')

 more off
