% fft_fwt.m ------ FFT suitable matrix for FWT
%
n = 64
row = 1:n;
%--------------------------------------------  Test 1
A = gallery('circul',row)'; % tranposed to COL

A_fft = transpose(ifft(transpose(fft(A))));

A_fwt = fwt(A,4);

subplot(221)
  spy(abs(A_fft)>0.1)
  title('FFT entries > 0.1'),ylabel('Matrix 1')
  x=0:(n/4):n;  set(gca,'ytick',x),set(gca,'xtick',x)
subplot(222)
  spy(abs(A_fwt)>0.1)
  hold on; spy(abs(A_fwt)>0.5,'xr'); hold off
  title('FWT entries > 0.1'),ylabel('Matrix 1')
  x=0:(n/4):n;  set(gca,'ytick',x),set(gca,'xtick',x)

%---------------------------------------------  Test 2
A = toeplitz(row);

A_fft = transpose(ifft(transpose(fft(A))));

A_fwt = fwt(A,4);

subplot(223)
  spy(abs(A_fft)>0.8)
  hold on; spy(abs(A_fft)>5,'xr'); hold off
  title('FFT entries > 0.8'),ylabel('Matrix 2')
  x=0:(n/4):n;  set(gca,'ytick',x),set(gca,'xtick',x)
subplot(224)
  spy(abs(A_fwt)>0.1)
  hold on; spy(abs(A_fwt)>5,'xr'); hold off
  title('FWT entries > 0.1'),ylabel('Matrix 2')
  x=0:(n/4):n;  set(gca,'ytick',x),set(gca,'xtick',x)

