% def_no.m --- shows that implicit deflation may not be useful for GMRES
%
% Take df=4 for deflating 4 smallest eigenvelues of A
help def_no
 rand('seed',0); n=10; A=rand(n)+eye(n).*diag(rand(n,1))+0.5*eye(n); 
 disp(['Test Matrix of size: ' num2str(size(A)) ' Set up ...'])
 df=4;       opt.disp=0;

disp('(Method 1)____________Right eigs: A*V1=V1*D1 ')
[V1 D1]=eigs(A,df,0,opt);  %right V1
[U1 R]=qr(V1,0);  % reduced QR
 T = R*D1*inv(R) ;
A_1 = A*( eye(n) + U1*(T\U1'));

disp('(Method 2)____________Left/Right eigs for AV=Vd and UA=sU NOT V''AV=d')
[V2 d]=eigs(A,df,0,opt); 
[U2 s]=eigs(A',df,0,opt);  % for Complex A, sort must be used!!!
  d=conj(diag(d)); V2=conj(V2);   % Both for conj(lambda) now
  uv=[]; for k=1:df, uv=[uv d(k)*(U2(:,k)'*V2(:,k))]; end  %% U2=V_left
A_2 = A*( eye(n) + V2*diag(1./uv)*U2');

disp('(Method 3)____________Hessenberg A*P=P*H + r ')
[V3 H]=hess_as(A,df);
 V3=V3(:,1:df); H=H(1:df,1:df);
[S T]=qr(H);  U3 = V3*S;
A_3 = A*( eye(n) + U3*(T\U3'));

%______________________________ Plot
close all
subplot(411)
plot(eig(A_1),'rx'); t=text(7.02,0,'M1');set(t,'Fontsize',12)
     axis([0 7 -1 1]);                   set(t,'Color','m')
subplot(412)
 plot(eig(A_2),'go'); t=text(7.02,0,'M2');set(t,'Fontsize',12)
     axis([0 7 -1 1]);                   set(t,'Color','m')

subplot(413)
 plot(eig(A),'k*'); t=text(7.02,0,'A');set(t,'Fontsize',12)
     axis([0 7 -1 1]);                   set(t,'Color','m')
subplot(414)
 plot(eig(A_3),'bs'); hold on;t=text(7.02,0,'M3');set(t,'Fontsize',12)
     axis([0 7 -1 1]);                   set(t,'Color','m')
 plot(real(eig(H)),imag(eig(H)),'g+'); hold off;
     xlabel('+ for H''s eigs  while  Box for A*M3')
