%================================================================
%circ_pre.m USAGE:
%            C = circ_pre(A, 1);  % ID=1 G Strang's for A=Toeplitz
%            C = circ_pre(A, 2);  % ID=2 T Chan's for   A=Toeplitz
%            C = circ_pre(A, 3);  % ID=3 T Chan's for general A
%================================================================
% e.g. (1)   rand('seed',0); n=8; a=rand(1,n); A=toeplitz(a,[a(1) rand(1,n-1)]);
%            Cs = circ_pre(A,1); er_1=[norm(Cs-A,1) norm(Cs-A,'fro')]
%            Cc = circ_pre(A,2); er_2=[norm(Cc-A,1) norm(Cc-A,'fro')]
%            Cc = circ_pre(A,3); er_3=[norm(Cc-A,1) norm(Cc-A,'fro')]
%      (2)   n=6; G=numgrid('A',n); A=full(delsq(G)); % Laplacian Annulus Domain
%            C1 = circ_pre(A,1); er_1=norm(C1-A,1)
%            C2 = circ_pre(A,2); er_2=norm(C2-A,1)
%            C3 = circ_pre(A,3); er_3=norm(C3-A,1)
%            mat_prt2(A,[],'|','Matrix A')
%            mat_prt2(C1,[],'|','Matrix C1 (Strang)')
%            mat_prt2(C2,[],'|','Matrix C2 (T Chan)')
%            mat_prt2(C3,[],'|','Matrix C3 (T Chan)')

function C = circ_approx( A, method )
  if nargin<1, help circ_pre; return; end
n=size(A,1); n2=n/2;

if ~exist('iout'); iout=0; else, global n_o sep_on; end % output control
    
if method==1 %%%-- COL of C
     Stra=[A(1:n2+1,1)' A(1,n-n2:-1:2)]; % Strang approximation - local
          C = gallery('circul',Stra)';
elseif method==2
     wei = (1:(n-1))/n; % T Chan's Toeplitz weights  -- COL of C
     Chan=[A(1,1) wei.*A(1,n:-1:2)+(1-wei).*A(2:n,1)'];
          C = gallery('circul',Chan)'; 
else
   for L=0:(n-1)  % L=\ell  %%% COL of C
    s = 0; for j=1:n, s=s+ A(mod(j+L-1,n)+1,j); end
    Chan(L+1) = s/n;
   end
          C = gallery('circul',Chan)'; 
end

