% ch8.m -- Illustrate various permutations of a DWT
% 
% Usage :  ch8(n,word,levs)  n = the matrix size (for two internal examples)
%                         word = wavelet order
%                         levs = wavelet levels requested
%  e.g.  ch8(64,4,3) % Daub 4 for 3 levels

function ch8(n,word,lmax)
if nargin<1,help ch8; return; end
if nargin<2, word=4; end
    levi=max(2, round( log(n)/log(2) )-4) ;  
if nargin<3, lmax=levi; end
disp('-----------------------------Caldron-Zygomon matrix-------')
        A = cz(n,2); plot_now(A,word,lmax);figure
disp('-----------------------------A simple diagonal matrix-----')
A=diag(rand(n,1))*2; plot_now(A,word,lmax)

function plot_now(A,word,lmax)
  n=size(A,1); r=1:n; h=10/n; 
A0=fwt(A,word,1,1,lmax); 
A1=perm0(A0,1,1,lmax); 
Aa=perma(A0,1,1,lmax); 
subplot(221);
 spy(abs(A(r,r))>h), title('Orig A'); 
subplot(223);
 spy(abs(A0(r,r))>h), title('Std DWT'); 
subplot(222);
 spy(abs(A1(r,r))>h), t=title('The DWTPer'); set(t,'color','r')
subplot(224);
 spy(abs(Aa(r,r))>h), t=title('The DWTPerMod'); set(t,'color','m')
  count=0;
 for j=0:lmax
 for extra=0:1
  count=count+1;
  Figure(count)
  A2=perm0(A0,1,1,lmax,j, extra); 
  spy(abs(A2(r,r))>h)
  t=title(['DWT Per' num2str(j) ':  diag levs='...
        num2str(j) '/' num2str(lmax) 'Extra ' num2str(extra)]);
  if extra==0
    if j==0
     set(t,'color','m'), t=ylabel('DWTPerMod'); set(t,'color','m')
     check_mod = norm(A2-Aa,1)
    end
    if j==lmax
     set(t,'color','r'), t=ylabel('DWTPer'); set(t,'color','r')
     check_per = norm(A2-A1,1)
    end
  end
 end %extra
 end %j
return

function Figure(num)
if rem(num-1,4)==0,figure; end
num=rem(num-1,4)+1;
str = sprintf('subplot(2,2,%d)',num); eval(str)
