% Usage:   T = BTTB(R,id)
% id=0: For matrix R_{2n-1x2n-1}, T will be the general BTTB matrix n^2xn^2
% id=1: For matrix R_{nxn}, T will be the symmetric BTTB matrix n^2xn^2
% e.g. R=round(rand(4)*14-5), A=BTTB(R);
%      mat_pr0(A,4,1,0)
% %or  S=round(rand(7)*10-5), B=BTTB(S,0);
%      mat_pr0(B,4,1,0)
function C = BTTB(R,id)
    if nargin<1 | nargin>3
       help bttb; return
    end
      n21=size(R,1); C=[]; c=[];
    if nargin<2, id=1; end
if id==0 & mod(n21-1,2)~=0
  error('BTTB.m --- the input root R insufficient for forming a general BTTB')
end
      n=n21; if id==0;  n=(n21+1)/2;  end
      range=1:n;

if id==1 %%%%%%%% Symmetric BTTB Case %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for row=1:n
    for col=1:n
      c = R(:,abs(row-col)+1);
      C( (row-1)*n+range, (col-1)*n+range) = toeplitz(c);
    end 
end
else %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for row=1:n
    for col=1:n
      k = n + row-col;
      r = R(n:-1:1,k);  c = R(n:n21,k);
      C( (row-1)*n+range, (col-1)*n+range) = toeplitz(c,r);
    end 
end
end  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 Y='No';if id==1;Y='Yes'; end
 fprintf('\t%s: T done: %d x %d  (symmetry = %s) \n',mfilename,size(C),Y)
