% Usage:   T = BCCB(R)
% For matrix R_{nxn}, T will be the BCCB matrix n^2xn^2
% e.g. R=round(rand(4)*10-5), A=BCCB(R);
%      mat_pr0(A,4,1,0)
function C = BCCB(R)
    if nargin<1 | nargin>1
       help bccb; return
    end
      n=size(R,1); C=[]; c=[]; range=1:n;

for row=1:n
    for col=1:n
      k = row-col+1;
      if k<1, k = n+1 + row-col; end
      c = R(:,k);
      C( (row-1)*n+range, (col-1)*n+range) = gallery('circul',c)';
    end 
end
 fprintf('\t%s: T done: %d x %d\n',mfilename,size(C))
