%_____________________________________
% bandg => banded matrix with a gap
% -----------------------------------
%B = bandg(A)  % extract a diagonal banded matrix out of A (mu=semi-bandwidth)
%B = bandg(A,mu)
%B = bandg(A, d_L,d_U, mu_L,mu_U)   % banded with a gap
%B = bandg(A, d_L,d_U, mu_L,mu_U,tol)  % tol is for optional thresh
%
%e.g.  Ex_1=rand(64); [B]=bandg(Ex_1,5,5,4,2); spy(B)
%                hold on, spy(diag(diag(Ex_1)),'ro'); hold off
%
%ALSO  banda => banded arrow extraction
%      bandb => banded block extraction

function B=bandg(A,d_L,d_U,mu,mu2,tol)
if nargin<1,help bandg; return; end
if nargin<2,mu=1; end
if nargin<3,mu2=mu; d_L=0;d_U=0; end
if nargin<5 & nargin>2, help bandg; inputs=nargin, return; end
B=tril(tril(A,mu2+d_U)',mu+d_L)';
S=tril(tril(A,d_U)',d_L)';
B = B - S + diag(diag(A));
if nargin>5
   B=sparse(B);
   B=B.*(abs(B)+diag(1:length(B))*tol>tol); 
end

