%B = banda(A)  % extract a diagonal banded arrow matrix out of A 
%B = banda(A,mu)
%B = banda(A,mu_L,mu_U,gam1,gam2)    % Bordering gam1 + gam2
%B = banda(A,mu_L,mu_U,gam1,gam2,tol)  % tol is for optional thresh
%
% e.g.  Ex_1=rand(64); B=banda(Ex_1,2,5,4,2); spy(B)
%       hold on, spy(diag(diag(Ex_1)),'ro'); hold off
%______________________________________
%ALSO  banda => banded arrow extraction
%      bandg => banded matrix with a gap 

function B=banda(A,mu,mu2,gam1,gam2,tol)
  if nargin<1,help banda; return; end
  if nargin<2,mu=1; end
  if nargin<3,mu2=mu; end
  if nargin<4,gam1=0; gam2=0; end
  if nargin<5,gam2=0; end
[m n]=size(A);
B=tril(tril(A(1:m-gam1,1:n-gam2),mu2)',mu)';
B=[B; A(m-gam1+1:m,1:n-gam2)];
B=[B  A(:,n-gam2+1:n)];
if nargin>5
   B=sparse(B);
   B=B.*(abs(B)+diag(1:length(B))*tol>tol); 
end
